-- opens a popup window which asks if you really want to exit the game

--LOAD BUTTON GRAPHICS (should already be loaded but just to be sure)
lua_init_texture("yes", "data/images/buttons/yes_btn.png", FM_NEAREST, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("yes_act", "data/images/buttons/yes_btn_act.png", FM_NEAREST, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("no", "data/images/buttons/no_btn.png", FM_NEAREST, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("no_act", "data/images/buttons/no_btn_act.png", FM_NEAREST, WM_REPEAT,WM_CLAMP,AM_MODULATE)

--background (total black)
local scale = 1000
lua_init_texture("menu_background", "data/images/effects/black.png", FM_NEAREST, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua:create_sprite("background", ST_TEXTURED,"menu_background",      0, 0) 
lua:sprite_shape("background",ST_TEXTURED,                          scale * 16.0, scale * 16.0)
lua:textured_sprite_tex_coords("background", ST_TEXTURED,           1.0, 1.0, 1.0, 1.0)
lua:sprite_color("background",                                       1.0,1.0,1.0,1.0)
lua:convert_to_hud("background")
popup_background = g_level.upload("background",lua:get_num_layers()-1)   --number of layers is 5, thus the index of the upperst layer is 4


--fade in
fade_in(2)

--text
lua:create_text("game_over","comic_sans",0,150,0.0,0.75) --0,0
lua:text_color("game_over",1.0,1.0,1.0,1.0)
lua:add_text("game_over", "Do you really wan't to quit?")
lua:add_text("game_over", "None of your game will be saved.")
--lua:convert_to_hud("game_over")
popup_text = g_level.upload("game_over",lua:get_num_layers()-1)

--button graphics
--yes
local scale = 0.30
local x_all = 50 --lua:get_camera_x()
local y_all = -100 --lua:get_camera_y() -100
lua:create_sprite("yes", ST_TEXTURED,"yes",                      -105.0 + x_all, 0.0 + y_all) 
lua:sprite_shape("yes",ST_TEXTURED,                             scale * 512.0, scale * 256.0)
lua:textured_sprite_tex_coords("yes", ST_TEXTURED,              0.0, 0.0, 1.0, 1.0)

lua:create_sprite("yes_act", ST_TEXTURED,"yes_act",                  -105.0 + x_all, 0.0 + y_all) 
lua:sprite_shape("yes_act",ST_TEXTURED,                             scale * 512.0, scale * 256.0)
lua:textured_sprite_tex_coords("yes_act", ST_TEXTURED,              0.0, 0.0, 1.0, 1.0)

--no
lua:create_sprite("no", ST_TEXTURED,"no",                       105.0 + x_all, 0.0 + y_all) 
lua:sprite_shape("no",ST_TEXTURED,                             scale * 512.0, scale * 256.0)
lua:textured_sprite_tex_coords("no", ST_TEXTURED,              0.0, 0.0, 1.0, 1.0)

lua:create_sprite("no_act", ST_TEXTURED,"no_act",                   105.0 + x_all, 0.0 + y_all) 
lua:sprite_shape("no_act",ST_TEXTURED,                             scale * 512.0, scale * 256.0)
lua:textured_sprite_tex_coords("no_act", ST_TEXTURED,              0.0, 0.0, 1.0, 1.0)

--buttons
lua:create_button("yes_button","yes","yes_act", "","","data/scripts/lvl_menu.lua") --exit
lua:create_button("no_button","no","no_act", "","",popup_previous_script) --load previous window
lua:button_dependencies("yes_button","","","","no_button")  --name: button name. button_up. button_down. button_left. button_right.
lua:button_dependencies("no_button","","","yes_button","")
lua:set_focused_button("yes_button")  -- must be done before upload...
popup_button1 = g_level.upload("no_button",lua:get_num_layers()-1)
popup_button2 = g_level.upload("yes_button",lua:get_num_layers()-1)

lua:set_game_state(GS_MENU)
